﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using MvcSample.Services;
using MvcSample.Model;

// Więcej informacji na temat włączenia API dla pustego projektu znajdziesz na stronie https://go.microsoft.com/fwlink/?LinkID=397860.

namespace MvcSample.Controllers
{
    [Route("api/[controller]")]
    public class LinksController : Controller
    {
        private readonly ILinkRepository db;
        public LinksController(ILinkRepository repository)
        {
            db = repository;
        }

        [HttpGet]
        public IEnumerable<Link> Get()
        {
            return db.GetLinks();
        }


        [HttpGet("{id}")]
        public Link Get(int id)
        {
            return db.GetLinks().SingleOrDefault(l=>l.Id==id);
        }
    }
}
